﻿<?php
include 'conexao.php';

// Verifica se o ID do aluno e o ID da turma foram enviados
if (isset($_GET['aluno_id']) && isset($_GET['turma_id'])) {
    $aluno_id = $_GET['aluno_id'];
    $turma_id = $_GET['turma_id'];

    // Inicia uma transação
    $conn->begin_transaction();

    try {
        // Passo 1: Remover da tabela 'matriculas'
        // Assumindo que você tem uma tabela 'matriculas' que liga alunos a turmas
        $stmt_matriculas = $conn->prepare("DELETE FROM matriculas WHERE aluno_id = ?");
        $stmt_matriculas->bind_param("i", $aluno_id);
        $stmt_matriculas->execute();
        $stmt_matriculas->close();

        // Passo 2: Remover da tabela 'alunos'
        $stmt_alunos = $conn->prepare("DELETE FROM alunos WHERE id = ?");
        $stmt_alunos->bind_param("i", $aluno_id);
        $stmt_alunos->execute();
        $stmt_alunos->close();

        // Confirma a transação
        $conn->commit();

        // Redireciona de volta para a lista atualizada da turma
        header("Location: " . $_SERVER['HTTP_REFERER'] . "?turma_id=" . $turma_id);
        exit();

    } catch (mysqli_sql_exception $e) {
        // Em caso de erro, desfaz a transação
        $conn->rollback();
        echo "Erro ao remover o aluno: " . $e->getMessage();
    }
} else {
    echo "ID do aluno ou da turma não especificado.";
}
?>